/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xml;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.xml.InternalContext;
import org.castor.xml.JavaNaming;
import org.castor.xml.JavaNamingImpl;
import org.castor.xml.XMLNaming;
import org.castor.xml.XMLProperties;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLSerializerFactory;
import org.exolab.castor.xml.util.DefaultNaming;
import org.exolab.castor.xml.util.ResolverStrategy;
import org.exolab.castor.xml.util.XMLParserUtils;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractInternalContext
implements InternalContext {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final Log LOG = LogFactory.getFactory().getInstance(AbstractInternalContext.class);
    private AbstractProperties _properties = XMLProperties.newInstance();
    private XMLClassDescriptorResolver _xmlClassDescriptorResolver;
    private Introspector _introspector;
    private ResolverStrategy _resolverStrategy;
    private MappingLoader _mappingLoader;
    private XMLNaming _xmlNaming;
    @Inject
    private JavaNaming _javaNaming = new JavaNamingImpl(this);
    private ClassLoader _classLoader;
    private NodeType _primitiveNodeType;
    private RegExpEvaluator _regExpEvaluator;

    public void addMapping(Mapping mapping) throws MappingException {
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
        this._xmlClassDescriptorResolver.setMappingLoader(mappingLoader);
    }

    public void addClass(Class clazz) throws ResolverException {
        this._xmlClassDescriptorResolver.addClass(clazz);
    }

    public void addClasses(Class[] clazzes) throws ResolverException {
        this._xmlClassDescriptorResolver.addClasses(clazzes);
    }

    public void addPackage(String packageName) throws ResolverException {
        this._xmlClassDescriptorResolver.addPackage(packageName);
    }

    public void addPackages(String[] packageNames) throws ResolverException {
        this._xmlClassDescriptorResolver.addPackages(packageNames);
    }

    public void setResolver(XMLClassDescriptorResolver xmlClassDescriptorResolver) {
        this._xmlClassDescriptorResolver = xmlClassDescriptorResolver;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName == null) {
            IllegalArgumentException iae = new IllegalArgumentException("setProperty must not be called with a propertyName == null");
            LOG.warn((Object)iae.getMessage());
            throw iae;
        }
        if (propertyName.equals("org.exolab.castor.xml.naming")) {
            if (value instanceof String) {
                this.setXMLNaming((String)value);
            } else if (value instanceof XMLNaming) {
                this.setXMLNaming((XMLNaming)value);
            } else {
                IllegalArgumentException iae = new IllegalArgumentException("XML Naming can only be set to a String or an implementation of XMLNaming");
                LOG.warn((Object)iae.getMessage());
                throw iae;
            }
        }
        if (propertyName.equals("org.castor.xml.java.naming")) {
            if (value instanceof String) {
                this.setJavaNaming((String)value);
            } else if (value instanceof JavaNaming) {
                this.setJavaNaming((JavaNaming)value);
            } else {
                IllegalArgumentException iae = new IllegalArgumentException("Java Naming can only be set to a String or an implementation of JavaNaming");
                LOG.warn((Object)iae.getMessage());
                throw iae;
            }
        }
        this._primitiveNodeType = null;
        this._regExpEvaluator = null;
        this.setPropertyInternal(propertyName, value);
    }

    public Object getProperty(String propertyName) {
        return this._properties.getObject(propertyName);
    }

    public XMLNaming getXMLNaming() {
        if (this._xmlNaming != null) {
            return this._xmlNaming;
        }
        String prop = this._properties.getString("org.exolab.castor.xml.naming", null);
        this.setXMLNaming(prop);
        return this._xmlNaming;
    }

    public XMLNaming getXMLNaming(ClassLoader classLoader) {
        return this.getXMLNaming();
    }

    public JavaNaming getJavaNaming() {
        return this._javaNaming;
    }

    public Parser getParser() {
        return this.getParser(null);
    }

    public Parser getParser(String features) {
        return XMLParserUtils.getParser(this._properties, features);
    }

    public XMLReader getXMLReader() {
        return this.getXMLReader(null);
    }

    public XMLReader getXMLReader(String features) {
        SAXParser saxParser;
        XMLReader reader = null;
        Boolean validation = this._properties.getBoolean("org.exolab.castor.parser.validation");
        Boolean namespaces = this._properties.getBoolean("org.exolab.castor.parser.namespaces");
        String readerClassName = this._properties.getString("org.exolab.castor.parser");
        if ((readerClassName == null || readerClassName.length() == 0) && (saxParser = XMLParserUtils.getSAXParser(validation, namespaces)) != null) {
            try {
                reader = saxParser.getXMLReader();
            }
            catch (SAXException e) {
                LOG.error((Object)Messages.format((String)"conf.configurationError", (Object)e));
            }
        }
        if (reader == null) {
            if (readerClassName == null || readerClassName.length() == 0 || readerClassName.equalsIgnoreCase("xerces")) {
                readerClassName = "org.apache.xerces.parsers.SAXParser";
            }
            reader = XMLParserUtils.instantiateXMLReader(readerClassName);
        }
        XMLParserUtils.setFeaturesOnXmlReader(this._properties.getString("org.exolab.castor.sax.features", features), this._properties.getString("org.exolab.castor.sax.features-to-disable", ""), validation, namespaces, reader);
        return reader;
    }

    public NodeType getPrimitiveNodeType() {
        if (this._primitiveNodeType != null) {
            return this._primitiveNodeType;
        }
        String prop = this._properties.getString("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (prop == null) {
            return null;
        }
        this._primitiveNodeType = NodeType.getNodeType(prop);
        return this._primitiveNodeType;
    }

    public RegExpEvaluator getRegExpEvaluator() {
        if (this._regExpEvaluator != null) {
            return this._regExpEvaluator;
        }
        String className = this._properties.getString("org.exolab.castor.regexp", "");
        if (className.length() == 0) {
            this._regExpEvaluator = null;
        } else {
            try {
                Class<?> regExpEvalClass = Class.forName(className);
                this._regExpEvaluator = (RegExpEvaluator)regExpEvalClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(Messages.format((String)"conf.failedInstantiateRegExp", (Object)className, (Object)e));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(Messages.format((String)"conf.failedInstantiateRegExp", (Object)className, (Object)e));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(Messages.format((String)"conf.failedInstantiateRegExp", (Object)className, (Object)e));
            }
        }
        return this._regExpEvaluator;
    }

    public Serializer getSerializer() {
        return XMLParserUtils.getSerializer(this._properties);
    }

    public OutputFormat getOutputFormat() {
        return XMLParserUtils.getOutputFormat(this._properties);
    }

    protected XMLSerializerFactory getSerializerFactory(String serializerFactoryName) {
        return XMLParserUtils.getSerializerFactory(serializerFactoryName);
    }

    public DocumentHandler getSerializer(OutputStream output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputByteStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format((String)"conf.serializerNotSaxCapable", (Object)serializer.getClass().getName()));
        }
        return docHandler;
    }

    public DocumentHandler getSerializer(Writer output) throws IOException {
        Serializer serializer = this.getSerializer();
        serializer.setOutputCharStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format((String)"conf.serializerNotSaxCapable", (Object)serializer.getClass().getName()));
        }
        return docHandler;
    }

    public XMLClassDescriptorResolver getXMLClassDescriptorResolver() {
        return this._xmlClassDescriptorResolver;
    }

    public Introspector getIntrospector() {
        return this._introspector;
    }

    public ResolverStrategy getResolverStrategy() {
        return this._resolverStrategy;
    }

    public void setResolverStrategy(ResolverStrategy resolverStrategy) {
        this._resolverStrategy = resolverStrategy;
    }

    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
    }

    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    public void setJavaNaming(JavaNaming javaNaming) {
        this._javaNaming = javaNaming;
    }

    public void setJavaNaming(String javaNamingProperty) {
        if (javaNamingProperty == null || javaNamingProperty.length() == 0) {
            this._javaNaming = new JavaNamingImpl(this);
        } else {
            try {
                Class<?> cls = Class.forName(javaNamingProperty);
                this._javaNaming = (JavaNaming)cls.newInstance();
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("Failed to load JavaNaming: " + e);
                LOG.warn((Object)iae.getMessage());
                throw iae;
            }
        }
    }

    public void setXMLNaming(XMLNaming xmlNaming) {
        this._xmlNaming = xmlNaming;
        if (this._introspector != null) {
            this._introspector.setNaming(this._xmlNaming);
        }
    }

    public void setXMLNaming(String xmlNamingProperty) {
        if (xmlNamingProperty == null || xmlNamingProperty.equalsIgnoreCase("lower")) {
            this.setXMLNaming(new DefaultNaming());
        } else if (xmlNamingProperty.equalsIgnoreCase("mixed")) {
            DefaultNaming dn = new DefaultNaming();
            dn.setStyle((short)1);
            this.setXMLNaming(dn);
        } else {
            try {
                Class<?> cls = Class.forName(xmlNamingProperty);
                this.setXMLNaming((XMLNaming)cls.newInstance());
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("Failed to load XMLNaming: " + e);
                LOG.warn((Object)iae.getMessage());
                throw iae;
            }
        }
        if (this._xmlNaming == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Failed to correctly set XMLNaming; property was: " + xmlNamingProperty);
            LOG.warn((Object)iae.getMessage());
            throw iae;
        }
    }

    public void setProperty(String propertyName, boolean value) {
        this.setPropertyInternal(propertyName, value);
    }

    private void setPropertyInternal(String propertyName, Object value) {
        Object oldValue = this._properties.getObject(propertyName);
        if (oldValue == null) {
            if (value != null) {
                this._properties.put(propertyName, value);
                this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, value);
            }
        } else if (!oldValue.equals(value)) {
            this._properties.put(propertyName, value);
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, value);
        }
    }

    public Boolean getBooleanProperty(String propertyName) {
        return this._properties.getBoolean(propertyName);
    }

    public String getStringProperty(String propertyName) {
        return this._properties.getString(propertyName);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        if (this._xmlClassDescriptorResolver != null) {
            this._xmlClassDescriptorResolver.setClassLoader(classLoader);
        }
    }

    public void setXMLClassDescriptorResolver(XMLClassDescriptorResolver xmlClassDescriptorResolver) {
        this._xmlClassDescriptorResolver = xmlClassDescriptorResolver;
    }

    public void setIntrospector(Introspector introspector) {
        this._introspector = introspector;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public boolean getLenientIdValidation() {
        Boolean lenientIdValidation = this._properties.getBoolean("org.exolab.castor.xml.lenient.id.validation");
        if (lenientIdValidation == null) {
            String message = "Property lenientIdValidation must not be null";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return lenientIdValidation;
    }

    public boolean getLenientSequenceOrder() {
        Boolean lenientSequenceOrder = this._properties.getBoolean("org.exolab.castor.xml.lenient.sequence.order");
        if (lenientSequenceOrder == null) {
            String message = "Property lenientSequenceOrder must not be null";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return lenientSequenceOrder;
    }

    public Boolean getLoadPackageMapping() {
        return this._properties.getBoolean("org.exolab.castor.xml.loadPackageMappings");
    }

    public void setLoadPackageMapping(Boolean loadPackageMapping) {
        this._properties.put("org.exolab.castor.xml.loadPackageMappings", (Object)loadPackageMapping);
    }

    public Boolean getUseIntrospector() {
        return this._properties.getBoolean("org.castor.xml.class-resolver.use-introspection");
    }

    public void setUseIntrospector(Boolean useIntrospector) {
        this._properties.put("org.castor.xml.class-resolver.use-introspection", (Object)useIntrospector);
    }

    public boolean marshallingValidation() {
        Boolean marshallingValidation = this._properties.getBoolean("org.exolab.castor.marshalling.validation");
        if (marshallingValidation == null) {
            String message = "Property marshallingValidation must not be null";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return marshallingValidation;
    }

    public boolean strictElements() {
        Boolean strictElements = this._properties.getBoolean("org.exolab.castor.xml.strictelements");
        if (strictElements == null) {
            String message = "Property strictElements must not be null";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return strictElements;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

