/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontProvider;
import com.lowagie.text.Utilities;
import com.lowagie.text.html.Markup;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FontFactoryImp
implements FontProvider {
    private Properties trueTypeFonts = new Properties();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private Hashtable fontFamilies = new Hashtable();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.trueTypeFonts.setProperty("Courier".toLowerCase(), "Courier");
        this.trueTypeFonts.setProperty("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.trueTypeFonts.setProperty("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.trueTypeFonts.setProperty("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.trueTypeFonts.setProperty("Helvetica".toLowerCase(), "Helvetica");
        this.trueTypeFonts.setProperty("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.trueTypeFonts.setProperty("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.trueTypeFonts.setProperty("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.trueTypeFonts.setProperty("Symbol".toLowerCase(), "Symbol");
        this.trueTypeFonts.setProperty("Times-Roman".toLowerCase(), "Times-Roman");
        this.trueTypeFonts.setProperty("Times-Bold".toLowerCase(), "Times-Bold");
        this.trueTypeFonts.setProperty("Times-Italic".toLowerCase(), "Times-Italic");
        this.trueTypeFonts.setProperty("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.trueTypeFonts.setProperty("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("Courier");
        tmp.add("Courier-Bold");
        tmp.add("Courier-Oblique");
        tmp.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Helvetica");
        tmp.add("Helvetica-Bold");
        tmp.add("Helvetica-Oblique");
        tmp.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("Times-Roman");
        tmp.add("Times-Bold");
        tmp.add("Times-Italic");
        tmp.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), tmp);
        this.fontFamilies.put("Times-Roman".toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), tmp);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, Color color) {
        return this.getFont(fontname, encoding, embedded, size, style, color, true);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, Color color, boolean cached) {
        if (fontname == null) {
            return new Font(-1, size, style, color);
        }
        String lowercasefontname = fontname.toLowerCase();
        ArrayList tmp = (ArrayList)this.fontFamilies.get(lowercasefontname);
        if (tmp != null) {
            int s = style == -1 ? 0 : style;
            int fs = 0;
            boolean found = false;
            for (String f : tmp) {
                String lcf = f.toLowerCase();
                fs = 0;
                if (lcf.toLowerCase().indexOf("bold") != -1) {
                    fs |= 1;
                }
                if (lcf.toLowerCase().indexOf("italic") != -1 || lcf.toLowerCase().indexOf("oblique") != -1) {
                    fs |= 2;
                }
                if ((s & 3) != fs) continue;
                fontname = f;
                found = true;
                break;
            }
            if (style != -1 && found) {
                style &= ~fs;
            }
        }
        BaseFont basefont = null;
        try {
            try {
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null, true);
            }
            catch (DocumentException de) {
                // empty catch block
            }
            if (basefont == null) {
                if ((fontname = this.trueTypeFonts.getProperty(fontname.toLowerCase())) == null) {
                    return new Font(-1, size, style, color);
                }
                basefont = BaseFont.createFont(fontname, encoding, embedded, cached, null, null);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            return new Font(-1, size, style, color);
        }
        catch (NullPointerException npe) {
            return new Font(-1, size, style, color);
        }
        return new Font(basefont, size, style, color);
    }

    public Font getFont(Properties attributes) {
        String fontname = null;
        String encoding = this.defaultEncoding;
        boolean embedded = this.defaultEmbedding;
        float size = -1.0f;
        int style = 0;
        Color color = null;
        String value = attributes.getProperty("style");
        if (value != null && value.length() > 0) {
            Properties styleAttributes = Markup.parseAttributes(value);
            if (styleAttributes.isEmpty()) {
                attributes.put("style", value);
            } else {
                fontname = styleAttributes.getProperty("font-family");
                if (fontname != null) {
                    while (fontname.indexOf(44) != -1) {
                        String tmp = fontname.substring(0, fontname.indexOf(44));
                        if (this.isRegistered(tmp)) {
                            fontname = tmp;
                            continue;
                        }
                        fontname = fontname.substring(fontname.indexOf(44) + 1);
                    }
                }
                if ((value = styleAttributes.getProperty("font-size")) != null) {
                    size = Markup.parseLength(value);
                }
                if ((value = styleAttributes.getProperty("font-weight")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = styleAttributes.getProperty("font-style")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = styleAttributes.getProperty("color")) != null) {
                    color = Markup.decodeColor(value);
                }
                attributes.putAll((Map<?, ?>)styleAttributes);
                Enumeration<Object> e = styleAttributes.keys();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    attributes.put(o, styleAttributes.get(o));
                }
            }
        }
        if ((value = attributes.getProperty("encoding")) != null) {
            encoding = value;
        }
        if ("true".equals(attributes.getProperty("embedded"))) {
            embedded = true;
        }
        if ((value = attributes.getProperty("font")) != null) {
            fontname = value;
        }
        if ((value = attributes.getProperty("size")) != null) {
            size = Markup.parseLength(value);
        }
        if ((value = attributes.getProperty("style")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = attributes.getProperty("fontstyle")) != null) {
            style |= Font.getStyleValue(value);
        }
        String r = attributes.getProperty("red");
        String g = attributes.getProperty("green");
        String b = attributes.getProperty("blue");
        if (r != null || g != null || b != null) {
            int red = 0;
            int green = 0;
            int blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            color = new Color(red, green, blue);
        } else {
            value = attributes.getProperty("color");
            if (value != null) {
                color = Markup.decodeColor(value);
            }
        }
        if (fontname == null) {
            return this.getFont(null, encoding, embedded, size, style, color);
        }
        return this.getFont(fontname, encoding, embedded, size, style, color);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style) {
        return this.getFont(fontname, encoding, embedded, size, style, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded, float size) {
        return this.getFont(fontname, encoding, embedded, size, -1, null);
    }

    public Font getFont(String fontname, String encoding, boolean embedded) {
        return this.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public Font getFont(String fontname, String encoding, float size, int style, Color color) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, String encoding, float size, int style) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, String encoding, float size) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname, float size, Color color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, color);
    }

    public Font getFont(String fontname, String encoding) {
        return this.getFont(fontname, encoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String fontname, float size, int style, Color color) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, color);
    }

    public Font getFont(String fontname, float size, int style) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, style, null);
    }

    public Font getFont(String fontname, float size) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, size, -1, null);
    }

    public Font getFont(String fontname) {
        return this.getFont(fontname, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public void registerFamily(String familyName, String fullName, String path) {
        ArrayList<String> tmp;
        if (path != null) {
            this.trueTypeFonts.setProperty(fullName, path);
        }
        if ((tmp = (ArrayList<String>)this.fontFamilies.get(familyName)) == null) {
            tmp = new ArrayList<String>();
            tmp.add(fullName);
            this.fontFamilies.put(familyName, tmp);
        } else {
            int fullNameLength = fullName.length();
            boolean inserted = false;
            for (int j = 0; j < tmp.size(); ++j) {
                if (((String)tmp.get(j)).length() < fullNameLength) continue;
                tmp.add(j, fullName);
                inserted = true;
                break;
            }
            if (!inserted) {
                tmp.add(fullName);
            }
        }
    }

    public void register(String path) {
        this.register(path, null);
    }

    public void register(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                int i;
                Object[] allNames = BaseFont.getAllFontNames(path, "Cp1252", null);
                this.trueTypeFonts.setProperty(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    this.trueTypeFonts.setProperty(alias.toLowerCase(), path);
                }
                String[][] names = (String[][])allNames[2];
                for (int i2 = 0; i2 < names.length; ++i2) {
                    this.trueTypeFonts.setProperty(names[i2][3].toLowerCase(), path);
                }
                String fullName = null;
                String familyName = null;
                names = (String[][])allNames[1];
                block4: for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                    for (i = 0; i < names.length; ++i) {
                        if (!TTFamilyOrder[k].equals(names[i][0]) || !TTFamilyOrder[k + 1].equals(names[i][1]) || !TTFamilyOrder[k + 2].equals(names[i][2])) continue;
                        familyName = names[i][3].toLowerCase();
                        k = TTFamilyOrder.length;
                        continue block4;
                    }
                }
                if (familyName != null) {
                    String lastName = "";
                    names = (String[][])allNames[2];
                    block6: for (i = 0; i < names.length; ++i) {
                        for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                            if (!TTFamilyOrder[k].equals(names[i][0]) || !TTFamilyOrder[k + 1].equals(names[i][1]) || !TTFamilyOrder[k + 2].equals(names[i][2]) || (fullName = names[i][3]).equals(lastName)) continue;
                            lastName = fullName;
                            this.registerFamily(familyName, fullName, null);
                            continue block6;
                        }
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                if (alias != null) {
                    System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                }
                String[] names = BaseFont.enumerateTTCNames(path);
                for (int i = 0; i < names.length; ++i) {
                    this.register(path + "," + i);
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                BaseFont bf = BaseFont.createFont(path, "Cp1252", false);
                String fullName = bf.getFullFontName()[0][3].toLowerCase();
                String familyName = bf.getFamilyFontName()[0][3].toLowerCase();
                String psName = bf.getPostscriptFontName().toLowerCase();
                this.registerFamily(familyName, fullName, null);
                this.trueTypeFonts.setProperty(psName, path);
                this.trueTypeFonts.setProperty(fullName, path);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public int registerDirectory(String dir) {
        return this.registerDirectory(dir, false);
    }

    public int registerDirectory(String dir, boolean scanSubdirectories) {
        int count = 0;
        try {
            File file = new File(dir);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            String[] files = file.list();
            if (files == null) {
                return 0;
            }
            for (int k = 0; k < files.length; ++k) {
                try {
                    String suffix;
                    file = new File(dir, files[k]);
                    if (file.isDirectory()) {
                        if (!scanSubdirectories) continue;
                        count += this.registerDirectory(file.getAbsolutePath(), true);
                        continue;
                    }
                    String name = file.getPath();
                    String string = suffix = name.length() < 4 ? null : name.substring(name.length() - 4).toLowerCase();
                    if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                        File pfb = new File(name.substring(0, name.length() - 4) + ".pfb");
                        if (!pfb.exists()) continue;
                        this.register(name, null);
                        ++count;
                        continue;
                    }
                    if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix)) continue;
                    this.register(name, null);
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return count;
    }

    public int registerDirectories() {
        int count = 0;
        count += this.registerDirectory("c:/windows/fonts");
        count += this.registerDirectory("c:/winnt/fonts");
        count += this.registerDirectory("d:/windows/fonts");
        count += this.registerDirectory("d:/winnt/fonts");
        count += this.registerDirectory("/usr/share/X11/fonts", true);
        count += this.registerDirectory("/usr/X/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/openwin/lib/X11/fonts", true);
        count += this.registerDirectory("/usr/share/fonts", true);
        count += this.registerDirectory("/usr/X11R6/lib/X11/fonts", true);
        count += this.registerDirectory("/Library/Fonts");
        return count += this.registerDirectory("/System/Library/Fonts");
    }

    public Set getRegisteredFonts() {
        return Utilities.getKeySet(this.trueTypeFonts);
    }

    public Set getRegisteredFamilies() {
        return Utilities.getKeySet(this.fontFamilies);
    }

    public boolean isRegistered(String fontname) {
        return this.trueTypeFonts.containsKey(fontname.toLowerCase());
    }
}

