/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.EventDispatchingThread;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageXRefViewer
extends AbstractTool {
    int total_number_of_pictures = 0;
    JSpinner jSpinner = new JSpinner();
    JPanel image_panel = new JPanel();
    CardLayout layout = new CardLayout();

    public ImageXRefViewer() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("View Image XObjects", true, false, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().setLayout(new BorderLayout());
        JPanel master_panel = new JPanel();
        master_panel.setLayout(new BorderLayout());
        this.internalFrame.getContentPane().add((Component)master_panel, "Center");
        this.image_panel.setLayout(this.layout);
        this.jSpinner.addChangeListener(new SpinnerListener(this));
        this.image_panel.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.image_panel);
        master_panel.add((Component)scrollPane, "Center");
        JPanel spinner_panel = new JPanel();
        spinner_panel.setLayout(new BorderLayout());
        spinner_panel.add((Component)this.jSpinner, "Center");
        JLabel image_label = new JLabel();
        image_label.setHorizontalAlignment(0);
        image_label.setText("images");
        spinner_panel.add((Component)image_label, "North");
        master_panel.add((Component)spinner_panel, "North");
        System.out.println("=== Image XObject Viewer OPENED ===");
    }

    public void valueHasChanged(AbstractArgument arg) {
    }

    public void propertyChange(ChangeEvent evt) {
        int picture = Integer.parseInt(this.jSpinner.getValue().toString());
        if (picture < 0) {
            picture = 0;
            this.jSpinner.setValue("0");
        }
        if (picture >= this.total_number_of_pictures) {
            picture = this.total_number_of_pictures - 1;
            this.jSpinner.setValue(String.valueOf(picture));
        }
        this.layout.show(this.image_panel, String.valueOf(picture));
        this.image_panel.repaint();
    }

    public static void main(String[] args) {
        ImageXRefViewer tool = new ImageXRefViewer();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    public void execute() {
        this.total_number_of_pictures = 0;
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            EventDispatchingThread task = new EventDispatchingThread(){

                public Object construct() {
                    try {
                        PdfReader reader = new PdfReader(((File)ImageXRefViewer.this.getValue("srcfile")).getAbsolutePath());
                        for (int i = 0; i < reader.getXrefSize(); ++i) {
                            PdfStream pdfdict;
                            PdfObject pdfsubtype;
                            PdfObject pdfobj = reader.getPdfObject(i);
                            if (pdfobj == null || !pdfobj.isStream() || (pdfsubtype = (pdfdict = (PdfStream)pdfobj).get(PdfName.SUBTYPE)) == null || !pdfsubtype.toString().equals(PdfName.IMAGE.toString())) continue;
                            System.out.println("total_number_of_pictures: " + ImageXRefViewer.this.total_number_of_pictures);
                            System.out.println("height:" + pdfdict.get(PdfName.HEIGHT));
                            System.out.println("width:" + pdfdict.get(PdfName.WIDTH));
                            System.out.println("bitspercomponent:" + pdfdict.get(PdfName.BITSPERCOMPONENT));
                            byte[] barr = PdfReader.getStreamBytesRaw((PRStream)pdfdict);
                            Image im = Toolkit.getDefaultToolkit().createImage(barr);
                            ImageIcon ii = new ImageIcon(im);
                            JLabel label = new JLabel();
                            label.setIcon(ii);
                            ImageXRefViewer.this.image_panel.add((Component)label, String.valueOf(ImageXRefViewer.this.total_number_of_pictures++));
                        }
                    }
                    catch (InstantiationException ex) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ImageXRefViewer.this.internalFrame.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            };
            this.internalFrame.setCursor(Cursor.getPredefinedCursor(3));
            task.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    static {
        ImageXRefViewer.addVersion("$Id: ImageXRefViewer.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    class SpinnerListener
    implements ChangeListener {
        private ImageXRefViewer adaptee;

        SpinnerListener(ImageXRefViewer adaptee) {
            this.adaptee = adaptee;
        }

        public void stateChanged(ChangeEvent e) {
            this.adaptee.propertyChange(e);
        }
    }
}

