/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.components.barcode4j.OrientationEnum;
import net.sf.jasperreports.components.barcode4j.QRCodeBean;
import net.sf.jasperreports.components.barcode4j.QRCodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.renderers.BatikRenderer;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QRCodeSVGImageProducer
implements QRCodeImageProducer {
    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, QRCodeBean qrCodeBean, String message) {
        QRCodeWriter writer = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)qrCodeBean.getErrorCorrectionLevel().getErrorCorrectionLevel());
        BitMatrix matrix = null;
        SVGCanvasProvider provider = null;
        int margin = qrCodeBean.getMargin() == null ? 0 : qrCodeBean.getMargin();
        try {
            matrix = writer.encode(message, BarcodeFormat.QR_CODE, componentElement.getWidth() - margin, componentElement.getHeight() - margin, hints);
            provider = new SVGCanvasProvider(false, OrientationEnum.UP.getValue().intValue());
        }
        catch (WriterException e) {
            throw new JRRuntimeException(e);
        }
        catch (BarcodeCanvasSetupException e) {
            throw new JRRuntimeException(e);
        }
        Document svgDoc = provider.getDOM();
        Element svg = svgDoc.getDocumentElement();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        svg.setAttribute("width", String.valueOf(width));
        svg.setAttribute("height", String.valueOf(height));
        svg.setAttribute("viewBox", "0 0 " + width + " " + height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Element element = svgDoc.createElement("rect");
                element.setAttribute("x", String.valueOf(x));
                element.setAttribute("y", String.valueOf(y));
                element.setAttribute("width", "1");
                element.setAttribute("height", "1");
                if (matrix.get(x, y)) {
                    element.setAttribute("fill", "#" + JRColorUtil.getColorHexa(componentElement.getForecolor()));
                } else {
                    element.setAttribute("fill", "#" + JRColorUtil.getColorHexa(componentElement.getBackcolor()));
                }
                svgDoc.getFirstChild().appendChild(element);
            }
        }
        DOMSource source = new DOMSource(svgDoc);
        StringWriter outWriter = new StringWriter();
        StreamResult output = new StreamResult(outWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
        }
        catch (TransformerException e) {
            throw new JRRuntimeException(e);
        }
        String svgString = outWriter.toString();
        return new BatikRenderer(svgString, null);
    }
}

