/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.util.List;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileService;
import net.sf.jasperreports.data.DataFileServiceFactory;
import net.sf.jasperreports.engine.JasperReportsContext;

public class DataFileResolver {
    private final JasperReportsContext context;

    public static DataFileResolver instance(JasperReportsContext context) {
        return new DataFileResolver(context);
    }

    protected DataFileResolver(JasperReportsContext context) {
        this.context = context;
    }

    public DataFileService getService(DataFile dataFile) {
        List<DataFileServiceFactory> factories = this.context.getExtensions(DataFileServiceFactory.class);
        DataFileService dataService = null;
        if (factories != null) {
            for (DataFileServiceFactory factory : factories) {
                DataFileService service = factory.createService(this.context, dataFile);
                if (service == null) continue;
                dataService = service;
                break;
            }
        }
        return dataService;
    }
}

