/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;

public class DocxTableHelper
extends BaseHelper {
    private CutsInfo xCuts;
    private DocxCellHelper cellHelper;
    private DocxParagraphHelper paragraphHelper;
    private PrintPageFormat pageFormat;

    protected DocxTableHelper(JasperReportsContext jasperReportsContext, Writer writer, CutsInfo xCuts, boolean pageBreak, PrintPageFormat pageFormat) {
        super(jasperReportsContext, writer);
        this.xCuts = xCuts;
        this.cellHelper = new DocxCellHelper(jasperReportsContext, writer);
        this.paragraphHelper = new DocxParagraphHelper(jasperReportsContext, writer, pageBreak);
        this.pageFormat = pageFormat;
    }

    public DocxCellHelper getCellHelper() {
        return this.cellHelper;
    }

    public DocxParagraphHelper getParagraphHelper() {
        return this.paragraphHelper;
    }

    public void exportHeader() {
        this.write("  <w:tbl>\n");
        this.write("   <w:tblPr>\n");
        this.write("    <w:tblLayout w:type=\"fixed\"/>\n");
        this.write("   </w:tblPr>\n");
        this.write("   <w:tblGrid>\n");
        int leftColumnWidth = this.xCuts.getCutOffset(1) - this.xCuts.getCutOffset(0);
        leftColumnWidth -= Math.min(leftColumnWidth, this.pageFormat.getLeftMargin());
        this.write("    <w:gridCol w:w=\"" + (leftColumnWidth == 0 ? 1 : LengthUtil.twip(leftColumnWidth)) + "\"/>\n");
        for (int col = 2; col < this.xCuts.size() - 1; ++col) {
            this.write("    <w:gridCol w:w=\"" + LengthUtil.twip(this.xCuts.getCutOffset(col) - this.xCuts.getCutOffset(col - 1)) + "\"/>\n");
        }
        int rightColumnWidth = this.xCuts.getCutOffset(this.xCuts.size() - 1) - this.xCuts.getCutOffset(this.xCuts.size() - 2);
        rightColumnWidth -= Math.min(rightColumnWidth, this.pageFormat.getRightMargin());
        this.write("    <w:gridCol w:w=\"" + (rightColumnWidth == 0 ? 1 : LengthUtil.twip(rightColumnWidth)) + "\"/>\n");
        this.write("   </w:tblGrid>\n");
    }

    public void exportFooter() {
        this.write("  </w:tbl>\n");
    }

    public void exportRowHeader(int rowHeight, boolean allowRowResize) {
        this.write("   <w:tr>\n");
        this.write("    <w:trPr>\n");
        this.write("     <w:trHeight w:hRule=\"" + (allowRowResize ? "atLeast" : "exact") + "\" w:val=\"" + LengthUtil.twip(rowHeight) + "\" />\n");
        this.write("    </w:trPr>\n");
    }

    public void exportRowFooter() {
        this.write("   </w:tr>\n");
    }

    public void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan) {
        this.exportEmptyCell(gridCell, emptyCellColSpan, false, 0L, null);
    }

    public void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan, boolean startPage, long bookmarkIndex, String pageAnchor) {
        this.write("    <w:tc>\n");
        this.write("     <w:tcPr>\n");
        if (emptyCellColSpan > 1) {
            this.write("      <w:gridSpan w:val=\"" + emptyCellColSpan + "\" />\n");
        }
        if (gridCell != null) {
            this.cellHelper.exportProps(gridCell);
        }
        this.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph(startPage, bookmarkIndex, pageAnchor);
        this.write("    </w:tc>\n");
    }

    public void exportOccupiedCells(JRExporterGridCell gridCell) {
        this.exportOccupiedCells(gridCell, false, 0L, null);
    }

    public void exportOccupiedCells(JRExporterGridCell gridCell, boolean startPage, long bookmarkIndex, String pageAnchor) {
        this.write("    <w:tc>\n");
        this.write("     <w:tcPr>\n");
        if (gridCell.getColSpan() > 1) {
            this.write("      <w:gridSpan w:val=\"" + gridCell.getColSpan() + "\" />\n");
        }
        this.write("      <w:vMerge w:val=\"continue\" />\n");
        this.cellHelper.exportProps(gridCell.getElement(), gridCell);
        this.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph(startPage, bookmarkIndex, pageAnchor);
        this.cellHelper.exportFooter();
    }
}

