/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.PrintElementOriginator;

public class DefaultPrintElementOriginator
implements PrintElementOriginator {
    public static final String EXCEPTION_MESSAGE_KEY_MAXIMUM_ELEMENTS_NUMBER_REACHED = "fill.print.element.maximum.elements.number.reached";
    private final int sourceElementId;
    private final AtomicInteger printIdCounter;

    public DefaultPrintElementOriginator(int sourceElementId) {
        this.sourceElementId = sourceElementId;
        this.printIdCounter = new AtomicInteger(0);
    }

    @Override
    public int getSourceElementId() {
        return this.sourceElementId;
    }

    @Override
    public int generatePrintElementId() {
        int id = this.printIdCounter.incrementAndGet();
        if (id == 0) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MAXIMUM_ELEMENTS_NUMBER_REACHED, new Object[]{this.sourceElementId});
        }
        return id;
    }
}

