/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.IndexedDataSource;
import net.sf.jasperreports.engine.fill.DatasetSortInfo;

public class SortedDataSource
implements JRRewindableDataSource,
IndexedDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND = "data.sorted.field.not.found";
    private final List<SortRecord> records;
    private final Integer[] recordIndexes;
    private final Map<String, Integer> columnNamesMap = new HashMap<String, Integer>();
    private int currentIndex;
    private SortRecord currentRecord;

    public SortedDataSource(DatasetSortInfo sortInfo, List<SortRecord> records, Integer[] recordIndexes) {
        if (records.size() != recordIndexes.length) {
            throw new IllegalArgumentException("Record count " + records.size() + " doesn't match index count " + recordIndexes.length);
        }
        this.records = records;
        this.recordIndexes = recordIndexes;
        ListIterator<DatasetSortInfo.RecordField> it = sortInfo.getRecordFields().listIterator();
        while (it.hasNext()) {
            DatasetSortInfo.RecordField recordField = it.next();
            if (recordField.isVariable()) continue;
            this.columnNamesMap.put(recordField.getName(), it.previousIndex());
        }
        this.currentIndex = 0;
    }

    @Override
    public boolean next() {
        if (this.currentIndex >= this.recordIndexes.length) {
            return false;
        }
        int recordIndex = this.recordIndexes[this.currentIndex];
        this.currentRecord = this.records.get(recordIndex);
        ++this.currentIndex;
        return true;
    }

    public void setRecordFilteredIndex(int index) {
        this.currentRecord.markFiltered();
        this.currentRecord.setRecordIndex(index);
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.columnNamesMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND, new Object[]{jrField.getName()});
        }
        return this.currentRecord.fieldValue(fieldIndex);
    }

    @Override
    public void moveFirst() {
        this.currentIndex = 0;
    }

    @Override
    public int getRecordIndex() {
        return this.currentRecord.getRecordIndex();
    }

    public List<SortRecord> getRecords() {
        return this.records;
    }

    public static class SortRecord {
        private final Object[] values;
        private int recordIndex;
        private boolean filtered;

        public SortRecord(Object[] values, int recordIndex) {
            this.values = values;
            this.recordIndex = recordIndex;
            this.filtered = false;
        }

        protected void markFiltered() {
            this.filtered = true;
        }

        public Object fieldValue(int fieldIdx) {
            return this.values[fieldIdx];
        }

        public Object[] getValues() {
            return this.values;
        }

        protected void setRecordIndex(int recordIndex) {
            this.recordIndex = recordIndex;
        }

        public int getRecordIndex() {
            return this.recordIndex;
        }

        public boolean isFiltered() {
            return this.filtered;
        }
    }
}

