/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.sf.jasperreports.types.date.AbstractDateRange;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;

public class FixedDate
extends AbstractDateRange {
    private static final long serialVersionUID = 10200L;
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private String datePattern;
    private Date value;

    public FixedDate(String expression) {
        this(expression, null, null);
    }

    public FixedDate(String expression, TimeZone timeZone, String datePattern) {
        super(expression, timeZone);
        this.datePattern = datePattern;
        this.validateExpression(expression);
    }

    public FixedDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("NULL could not be used as a value");
        }
        this.value = date;
    }

    @Override
    protected void validateExpression(String expression) throws InvalidDateRangeExpressionException {
        super.validateExpression(expression);
        try {
            this.parse(expression);
        }
        catch (Exception pe) {
            throw new InvalidDateRangeExpressionException(expression);
        }
    }

    @Override
    public Date getStart() {
        if (this.value == null) {
            try {
                this.value = this.parse(this.expression);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.value;
    }

    @Override
    public Date getEnd() {
        return this.getStart();
    }

    private Date parse(String dateAsString, String pattern) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        if (this.timeZone != null) {
            dateFormat.setTimeZone(this.timeZone);
        }
        return dateFormat.parse(dateAsString);
    }

    protected String getDefaultPattern() {
        return DATE_PATTERN;
    }

    private Date parse(String dateAsString) throws Exception {
        if (this.datePattern != null) {
            return this.parse(dateAsString, this.datePattern);
        }
        Date result = this.parse(dateAsString, this.getDefaultPattern());
        this.datePattern = this.getDefaultPattern();
        return result;
    }
}

